#include <avr/wdt.h>
#include <Wire.h>
#include <SDI12.h>
#define DATAPIN 7 //水位水温センサPIN

SDI12 mySDI12(DATAPIN);
int SLAVE_ADDRESS = 0x04; //I2Caddress->0x04
int i2cSendMode = 1;      //I2CsendMode

int32_t WL = 0;           //WaterLevel
float WT = 0;             //WaterTemp
int32_t measureCount = 0; //計測回数
float val1 = 0;
float val2 = 0;
float val3 = 0;
float val4 = 0;

char charI2cWLWTRCsendByte[32];
char charI2cValSendMessage[32];

volatile unsigned long time_prev = 0, time_now;
unsigned long time_chatter = 20;
volatile unsigned int pulsecount = 0;
bool i2cConnectFlg = false;
volatile int wdt_counter = 0;

//雨量カウント
void raincount()
{
  time_now = millis(); //現在の割り込み時刻を取得
  if (time_now - time_prev > time_chatter)
  {
    pulsecount++;
    Serial.println("rain");
  }
  time_prev = time_now; //現在の割込時刻をtime_prevへ
}

//水位・水温測定
void tmMeasurement(char c)
{
  String command = "";
  String sendValue = "";
  int32_t getWL = 0;
  float getWT = 0.0;
  int32_t getEC = 0;
  command += c;

  command += "M!"; // SDI-12 measurement command format
  mySDI12.sendCommand(command);
  delay(1000);
  mySDI12.flush();

  command = "";
  command += c;
  command += "D0!"; // SDI-12 command to get data
  mySDI12.sendCommand(command);

  delay(500);

  if (mySDI12.available())
  {
    int32_t I = mySDI12.parseInt();
    int32_t D = mySDI12.parseInt();
    int32_t channel = mySDI12.parseInt();

    getWL = mySDI12.parseInt();
    getWT = mySDI12.parseFloat();
    getEC = mySDI12.parseInt();

    WL = getWL;
    WT = getWT;
  }

  mySDI12.flush();
  delay(500);
}

// Raspberry Piからメッセージ受信処理
void ReceiveMessage(int n)
{
  char getCmd = Wire.read();

  if (Wire.available())
  {
    getCmd = (char)Wire.read();
  }

  if (getCmd == 'A')
  {
    Serial.println('A');
    i2cSendMode = 1;
  }
  else if (getCmd == 'B')
  {
    Serial.println('B');
    i2cSendMode = 2;
  }
}

// Raspberry Piからメッセージ送信リクエスト処理
void RequestMessage()
{
  if (i2cSendMode == 1)
  {
    i2cWLWTRCSendMessage();
    i2cSendMode = 2;
  }
  else
  {
    i2cValSendMessage();
    i2cSendMode = 1;
  }
}

// 水位水温雨量送信処理
void i2cWLWTRCSendMessage()
{
  Wire.write(charI2cWLWTRCsendByte);
  i2cConnectFlg = true;
  wdt_counter = 0;
}

void i2cValSendMessage()
{
  Wire.write(charI2cValSendMessage);
  i2cConnectFlg = false;
  wdt_counter = 0;
}

void setup()
{
  measureCount = 0;
  Serial.begin(9600);
  analogReference(DEFAULT);

  pinMode(2, INPUT_PULLUP);
  attachInterrupt(0, raincount, RISING);

  mySDI12.begin();

  Wire.begin(SLAVE_ADDRESS);      //I2C接続を開始する
  Wire.onReceive(ReceiveMessage); //I2Cで受信したときに呼び出す関数を登録する
  Wire.onRequest(RequestMessage); //I2Cでリクエスト受信したときに呼び出す関数を登録する

  Serial.println("tameike iot start");
  delay(2000);
}

void loop()
{
  String tmpSendValue = "";
  measureCount++;

  tmMeasurement('0'); //水位水温測定

  tmpSendValue = "F,";
  tmpSendValue += String(pulsecount) + ",";
  tmpSendValue += String(WL) + ",";
  tmpSendValue += String(WT) + ",";
  tmpSendValue += "T";
  Serial.println(tmpSendValue);

  for (int i = 0; i < 32; i++)
  {
    if (i < tmpSendValue.length())
    {
      charI2cWLWTRCsendByte[i] = tmpSendValue[i];
    }
    else
    {
      charI2cWLWTRCsendByte[i] = '\0';
    }
  }

  tmpSendValue = "S,";
  tmpSendValue += String(val1) + ",";
  tmpSendValue += String(val2) + ",";
  tmpSendValue += String(val3) + ",";
  tmpSendValue += String(val4) + ",";
  tmpSendValue += "E";
  Serial.println(tmpSendValue);

  for (int i = 0; i < 32; i++)
  {
    if (i < tmpSendValue.length())
    {
      charI2cValSendMessage[i] = tmpSendValue[i];
    }
    else
    {
      charI2cValSendMessage[i] = '\0';
    }
  }

  // Serial.print("rainFall->");
  // Serial.println(pulsecount);
  // Serial.print("waterLevel->");
  // Serial.println(WL);
  // Serial.print("waterTemp->");
  // Serial.println(WT);

  delay(1000);

  if (i2cConnectFlg)
  {
    i2cConnectFlg = false;
    wdt_counter = 1;

    if (wdt_counter >= 0)
    {
      wdt_counter = 0;
      wdt_reset();
      wdt_enable(WDTO_2S);
      while (1)
      {
      };
    }
  }

  if (measureCount > 30)
  {
    i2cConnectFlg = false;
    wdt_reset();
    wdt_enable(WDTO_15MS);
    while (1)
    {
    };
  }

  delay(27000);
}
