SET
  SQL_MODE = "NO_AUTO_VALUE_ON_ZERO";

SET
  time_zone = "+00:00";

CREATE TABLE `waterLevelPredictions` (
  `id` int (11) NOT NULL,
  `waterLevel` varchar (32) NOT NULL,
  `waterTemperature` varchar (32) NOT NULL,
  `precipitation` varchar (32) NOT NULL,
  `val1` varchar (32) NOT NULL,
  `val2` varchar (32) NOT NULL,
  `val3` varchar (32) NOT NULL,
  `val4` varchar (32) NOT NULL,
  `measurementDate` datetime NOT NULL,
  `pre_1` varchar (32) DEFAULT NULL,
  `pre_2` varchar (32) DEFAULT NULL,
  `pre_3` varchar (32) DEFAULT NULL,
  `pre_4` varchar (32) DEFAULT NULL,
  `pre_5` varchar (32) DEFAULT NULL,
  `pre_6` varchar (32) DEFAULT NULL,
  `pre_7` varchar (32) DEFAULT NULL,
  `pre_8` varchar (32) DEFAULT NULL,
  `pre_9` varchar (32) DEFAULT NULL,
  `pre_10` varchar (32) DEFAULT NULL,
  `pre_11` varchar (32) DEFAULT NULL,
  `pre_12` varchar (32) DEFAULT NULL,
  `pre_13` varchar (32) DEFAULT NULL,
  `pre_14` varchar (32) DEFAULT NULL,
  `pre_15` varchar (32) DEFAULT NULL,
  `pre_16` varchar (32) DEFAULT NULL,
  `pre_17` varchar (32) DEFAULT NULL,
  `pre_18` varchar (32) DEFAULT NULL,
  `pre_19` varchar (32) DEFAULT NULL,
  `pre_20` varchar (32) DEFAULT NULL,
  `pre_21` varchar (32) DEFAULT NULL,
  `pre_22` varchar (32) DEFAULT NULL,
  `pre_23` varchar (32) DEFAULT NULL,
  `pre_24` varchar (32) DEFAULT NULL,
  `place_id` int (11) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE = InnoDB DEFAULT CHARSET = latin1;

CREATE TABLE `waterLevels` (
  `id` int (11) NOT NULL,
  `waterLevel` varchar (32) NOT NULL,
  `waterTemperature` varchar (32) NOT NULL,
  `precipitation` varchar (32) NOT NULL,
  `val1` varchar (32) NOT NULL,
  `val2` varchar (32) NOT NULL,
  `val3` varchar (32) NOT NULL,
  `val4` varchar (32) NOT NULL,
  `measurementDate` datetime NOT NULL,
  `place_id` int (11) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE = InnoDB DEFAULT CHARSET = latin1;

CREATE TABLE `places` (
  `id` int (11) NOT NULL,
  `name` varchar (256) NOT NULL,
  `viewName` varchar (256) NOT NULL,
  `overflowLevel` varchar (32) NOT NULL,
  `diff` int (11) NOT NULL,
  `lat` varchar (64) NOT NULL,
  `lon` varchar (64) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE = InnoDB DEFAULT CHARSET = utf8;

CREATE TABLE `predictPrecipitations` (
  `id` int (11) NOT NULL,
  `predictTime` datetime NOT NULL,
  `precipitation` varchar (64) NOT NULL,
  `place_id` int (11) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE = InnoDB DEFAULT CHARSET = utf8;

CREATE TABLE `settings` (
  `id` int (11) NOT NULL,
  `url` varchar (128) NOT NULL,
  `yumakeKey` varchar (128) NOT NULL,
  `lineChannel` varchar (128) NOT NULL,
  `lineAccesstoken` varchar (256) NOT NULL,
  `token` varchar (32) NOT NULL,
  `created` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `modified` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP
) ENGINE = InnoDB DEFAULT CHARSET = utf8;

ALTER TABLE
  `waterLevelPredictions`
ADD
  PRIMARY KEY (`id`);

ALTER TABLE
  `waterLevels`
ADD
  PRIMARY KEY (`id`);

ALTER TABLE
  `places`
ADD
  PRIMARY KEY (`id`);

ALTER TABLE
  `predictPrecipitations`
ADD
  PRIMARY KEY (`id`);

ALTER TABLE
  `settings`
ADD
  PRIMARY KEY (`id`);

ALTER TABLE
  `waterLevelPredictions`
MODIFY
  `id` int (11) NOT NULL AUTO_INCREMENT,
  AUTO_INCREMENT = 1;

ALTER TABLE
  `waterLevels`
MODIFY
  `id` int (11) NOT NULL AUTO_INCREMENT,
  AUTO_INCREMENT = 1;

ALTER TABLE
  `places`
MODIFY
  `id` int (11) NOT NULL AUTO_INCREMENT,
  AUTO_INCREMENT = 1;

ALTER TABLE
  `predictPrecipitations`
MODIFY
  `id` int (11) NOT NULL AUTO_INCREMENT,
  AUTO_INCREMENT = 1;

ALTER TABLE
  `settings`
MODIFY
  `id` int (11) NOT NULL AUTO_INCREMENT,
  AUTO_INCREMENT = 1;

INSERT INTO
  places (name, viewName, overflowLevel, diff, lat, lon)
values
  ('tameike', 'tameikeName', '0', 0, '34.694630', '135.757908');

INSERT INTO
  settings (url, yumakeKey, lineChannel, lineAccesstoken,token)
values
  ('tameike.com','yumakeKey', 'lineChannel', 'lineAccesstoken','token');